import java.sql.SQLException;
import java.util.*;
import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;

import examples.domain.Person;

public class PersonApp {

	public static void main(String[] args) throws  SQLException {
		SessionFactory sessionFactory = new Configuration().configure("Hibernate.cfg.xml").buildSessionFactory();
		Session session = sessionFactory.openSession();
	    Transaction tx = session.beginTransaction();
		
		//insert Person
	    System.out.println("insert Person");
		Person newPerson1 = new Person();
		newPerson1.setName("KIM");
		newPerson1.setBirthDate (new java.sql.Date(1978,1-1,1));
		newPerson1.setHeightInMeters(1.82);
		newPerson1.setWeightInKilograms(80.23);
		newPerson1.setIsMarried(true);
		session.save(newPerson1);
		
		Person newPerson2 = new Person();
		newPerson2.setName("LEE");
		newPerson2.setBirthDate (new java.sql.Date(1975,5-1,5));
		newPerson2.setHeightInMeters(1.57);
		newPerson2.setWeightInKilograms(45.23);
		newPerson2.setIsMarried(false);
		session.save(newPerson2);
		tx.commit();
		
		System.out.println();
		System.out.println("select all Persons");
		Criteria crit = session.createCriteria(Person.class);
		crit.addOrder(Order.asc("id"));
		List<Person> list = crit.list();
		System.out.println("Selected "+list.size()+" records.");
		for(int i=0; i< list.size();i++){
			System.out.println(list.get(i));
		
		}
		tx = session.beginTransaction();
		//update Person
		System.out.println();
		System.out.println("update Person");
		newPerson1.setHeightInMeters(1.93);
		newPerson1.setWeightInKilograms(86.36); 
		System.out.println();
		session.update(newPerson1);
		tx.commit();

	    Person person = (Person) session.get(Person.class,newPerson1.getId());
		System.out.println(person);
		
		//delete Person
		tx = session.beginTransaction();
		System.out.println();
		System.out.println("delete Person");
		session.delete(session.get(Person.class, newPerson1.getId()));
		//session.delete(session.get(Person.class, newPerson2.getId()));
		tx.commit();
		crit = session.createCriteria(Person.class);
		crit.addOrder(Order.asc("id"));
		list = crit.list();
		System.out.println("Selected "+list.size()+" records.");
		for(int i=0; i< list.size();i++){
			System.out.println(list.get(i));
		
		}
		
	}

}
