import java.sql.SQLException;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.criterion.Order;

import com.altibase.lob.*;



public class LobApp {

	
	public static void main(String[] args) throws  SQLException, InterruptedException{
		SessionFactory sessionFactory = new Configuration().configure().buildSessionFactory();
		Session session = sessionFactory.openSession();
	    Transaction tx = session.beginTransaction();

		StringBuffer msg=new StringBuffer("Existing Disk-based RDBMS (also known as Disk-Resident DBMSs or DRDBMSs), which has been favored by many for a long time due to the wide range of functions and convenient administrative tools that are typically available, are now facing performance issues owing to changes in DB application environments. These issues are attributable to the fact that RDBMSs use disks as their main data storage devices. Frequent disk I/O errors cannot but result in poor transaction- processing performance." );
		for(int i=0; i<10;i++){
        	msg.append(msg.toString());		
        }
        System.out.println(msg.toString().length());
        System.out.println(msg.toString().getBytes().length);
        Lobsample lob1 = new Lobsample(1,msg.toString(),msg.toString().getBytes());
        Lobsample lob2 = new Lobsample(2,msg.toString(),msg.toString().getBytes());
        session.save(lob1);
        session.save(lob2);
        tx.commit(); 
        Thread.sleep(10000);
		System.out.println();
		System.out.println("inserted lob");
		session.flush();
	    tx = session.beginTransaction();
		Lobsample Lobsample1 = (Lobsample) session.get(Lobsample.class,lob1.getLob_id());
		System.out.println(Lobsample1.getClobcolumn().substring(0, 100));
		System.out.println(Lobsample1.getBlobcolumn());
		Lobsample Lobsample2 = (Lobsample) session.get(Lobsample.class,lob1.getLob_id());
		System.out.println(Lobsample2.getClobcolumn().substring(0, 100));
		System.out.println(Lobsample2.getBlobcolumn());
		
		tx.commit(); 
	}

}
