import java.sql.SQLException;
import java.util.*;
import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;

import examples.domain.Person;

public class PersonApp {

	public static void main(String[] args) throws  SQLException {
		SessionFactory sessionFactory1 = new Configuration().configure("Hibernate.Altibase5.cfg.xml").buildSessionFactory();
		SessionFactory sessionFactory2 = new Configuration().configure("Hibernate.Altibase4.cfg.xml").buildSessionFactory();
		
		Session session1 = sessionFactory1.openSession();
		Session session2 = sessionFactory2.openSession();
	    
		Transaction tx1 = session1.beginTransaction();
	    //insert Person
	    System.out.println("insert Person");
		Person newPerson1 = new Person();
		newPerson1.setId(1);
		newPerson1.setName("KIM");
		newPerson1.setBirthDate (new java.sql.Date(1978,1-1,1));
		newPerson1.setHeightInMeters(1.82);
		newPerson1.setWeightInKilograms(80.23);
		newPerson1.setIsMarried(true);
		session1.save(newPerson1);
		tx1.commit();
		
		
		Transaction tx2 = session2.beginTransaction();
		Person newPerson2 = new Person();
		newPerson2.setId(2);
		newPerson2.setName("LEE");
		newPerson2.setBirthDate (new java.sql.Date(1975,5-1,5));
		newPerson2.setHeightInMeters(1.57);
		newPerson2.setWeightInKilograms(45.23);
		newPerson2.setIsMarried(false);
		session2.save(newPerson2);
		tx2.commit();
		
		System.out.println();
		System.out.println("select all Persons");
		
		Criteria crit = session1.createCriteria(Person.class);
		crit.addOrder(Order.asc("id"));
		List<Person> list = crit.list();
		System.out.println("Selected "+list.size()+" records.");
		for(int i=0; i< list.size();i++){
			System.out.println(list.get(i));
		
		}
		
		
		Criteria crit2 = session2.createCriteria(Person.class);
		crit2.addOrder(Order.asc("id"));
		List<Person> list2 = crit2.list();
		System.out.println("Selected "+list2.size()+" records.");
		for(int i=0; i< list2.size();i++){
			System.out.println(list2.get(i));
		
		}
		
		
	}

}
