import java.sql.SQLException;
import java.util.*;

import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;

import examples.domain.T1;
import examples.domain.T2;

public class NativeSQLApp {
	public static void main(String[] args) throws  SQLException {
		SessionFactory sessionFactory = new Configuration().configure("Hibernate.cfg.xml").buildSessionFactory();
		Session session = sessionFactory.openSession();
	    Query query = session.getNamedQuery("nativeSQLMove");
		Transaction tx = session.beginTransaction();
		int rows = query.executeUpdate();
		tx.commit();
		System.out.println(rows+" data moved");

		Criteria crit1 = session.createCriteria(T1.class);
		crit1.addOrder(Order.asc("c1"));
		crit1.setFirstResult(0);
		crit1.setMaxResults(20);
		crit1.setFetchSize(20);
		List<T1> list1 = crit1.list();
		System.out.println("Selected T1 : "+list1.size()+" records.");
		for(int i=0; i< list1.size();i++){
			System.out.println(list1.get(i));
		
		}

		Criteria crit2 = session.createCriteria(T2.class);
		crit2.addOrder(Order.asc("c1"));
		crit2.setFirstResult(0);
		crit2.setMaxResults(20);
		//crit2.setFetchSize(20);
		List<T2> list2 = crit2.list();
		
		System.out.println("Selected T2 : "+list2.size()+" records.");
		for(int i=0; i< list2.size();i++){
			System.out.println(list2.get(i).getC1()+", "+list2.get(i).getC2()+", "+list2.get(i).getC3());
		
		}
	}
}
