import examples.domain.*;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PersonApp {

	public static void main(String[] args) throws IOException, SQLException, InterruptedException {
		Resource resource = new ClassPathResource("applicationContext.xml");
		BeanFactory factory = new XmlBeanFactory(resource);
		PersonDao personDao = (PersonDao)factory.getBean("personDao");
  
		
		//insert Person
		Person newPerson1 = new Person();
		newPerson1.setName("KIM");
		newPerson1.setBirthDate (new java.sql.Date(1978,1-1,1));
		newPerson1.setHeightInMeters(1.82);
		newPerson1.setWeightInKilograms(80.23);
		personDao.insertPerson(newPerson1);
	
		Person newPerson2 = new Person();
		newPerson2.setName("LEE");
		newPerson2.setBirthDate (new java.sql.Date(1975,5-1,5));
		newPerson2.setHeightInMeters(1.57);
		newPerson2.setWeightInKilograms(45.23);
		personDao.insertPerson(newPerson2);
		System.out.println();
		System.out.println("insert Person");
		
		List<Person> list = personDao.getAllPersons();
		System.out.println("Selected "+list.size()+" records.");
		for(int i=0; i< list.size();i++){
			System.out.println(list.get(i).toString());
		}
	
		//update Person
		newPerson1.setHeightInMeters(1.93);
		newPerson1.setWeightInKilograms(86.36);
		personDao.updatePerson(newPerson1);
		System.out.println();
		System.out.println("update Person");
		Person person = personDao.getPerson(newPerson1.getId());
		System.out.println();
		System.out.println("update Person");
		System.out.println(person);		
		
		
		//delete Person
		personDao.deletePerson(newPerson1.getId());
		personDao.deletePerson(newPerson2.getId());
		System.out.println();
		System.out.println("delete Person");
		list = personDao.getAllPersons();
		System.out.println("Selected "+list.size()+" records.");
		for(int i=0; i< list.size();i++){
			System.out.println(list.get(i).toString());
		
		}
		
		
	}

}
