package examples.domain;

import java.sql.SQLException;
import java.util.*;

import org.hibernate.SessionFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;


public class PersonDao {
	private Session session;
	//private PlatformTransaction;
	public PersonDao(SessionFactory sessionFactory) {
		session = sessionFactory.openSession();
	}
	
	public PersonDao() {
		
	}
	
	public void insertPerson(Person p) throws SQLException{
		//Transaction tx = session.beginTransaction();
		session.save(p);
		//tx.commit();
	}
	
	public void updatePerson(Person p) throws SQLException{
		//Transaction tx = session.beginTransaction();
		session.update(p);
		//tx.commit();
	}
	public void deletePerson(int per_id) throws SQLException{
		//Transaction tx = session.beginTransaction();
		session.delete(session.get(Person.class, per_id));
		//tx.commit();
	}
	public Person getPerson(int per_id) throws SQLException{
		Person person = (Person) session.get(Person.class, per_id);
		return person;
	}
	public List<Person> getAllPersons() throws SQLException{
		Criteria crit = session.createCriteria(Person.class);
		crit.addOrder(Order.asc("id"));
		List<Person> list = crit.list();
		return list;
	}
	
}
